-- SQL inicial para crear la base de datos y tablas mínimas
CREATE DATABASE IF NOT EXISTS veterinaria_db DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE veterinaria_db;

-- Tabla usuarios
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(150) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('user','admin') NOT NULL DEFAULT 'user',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- Tabla mascotas
CREATE TABLE IF NOT EXISTS pets (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  type VARCHAR(80) NOT NULL,
  photo VARCHAR(255) DEFAULT NULL,
  owner_id INT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (owner_id) REFERENCES users(id) ON DELETE SET NULL
) ENGINE=InnoDB;

-- Usuarios de prueba
INSERT INTO users (name,email,password,role) VALUES
('Admin','admin@local', '$2y$10$ADMINPLACEHOLDERADMINPLACEHOLDERAAA', 'admin'),
('Usuario','user@local', '$2y$10$USERPLACEHOLDERUSERPLACEHOLDERAAA', 'user');
