<?php
include 'includes/config.php';
$errors=[];
if($_SERVER['REQUEST_METHOD']==='POST'){
    $email = $mysqli->real_escape_string($_POST['email']);
    $password = $_POST['password'];
    $stmt = $mysqli->prepare('SELECT id,name,password,role FROM users WHERE email=? LIMIT 1');
    $stmt->bind_param('s',$email);
    $stmt->execute();
    $res = $stmt->get_result();
    if($user = $res->fetch_assoc()){
        if(password_verify($password, $user['password'])){
            $_SESSION['user_id']=$user['id'];
            $_SESSION['name']=$user['name'];
            $_SESSION['role']=$user['role'];
            header('Location: index.php');
            exit;
        } else {
            $errors[]='Contraseña incorrecta';
        }
    } else {
        $errors[]='Usuario no encontrado';
    }
}
include 'includes/header.php';
?>
<h2>Iniciar sesión</h2>
<div class="card">
<?php foreach($errors as $e) echo '<p class="small">'.$e.'</p>'; ?>
<form method="post">
 <div class="form-row"><label>Correo</label><input required type="email" name="email"></div>
 <div class="form-row"><label>Contraseña</label><input required type="password" name="password"></div>
 <button type="submit">Entrar</button>
</form>
</div>
<?php include 'includes/footer.php'; ?>