<?php
include 'includes/config.php';
$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $mysqli->real_escape_string($_POST['name']);
    $email = $mysqli->real_escape_string($_POST['email']);
    $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
    // default role: user
    $role = 'user';
    $stmt = $mysqli->prepare('INSERT INTO users (name,email,password,role) VALUES (?,?,?,?)');
    $stmt->bind_param('ssss',$name,$email,$pass,$role);
    if($stmt->execute()){
        header('Location: login.php');
        exit;
    } else {
        $errors[] = 'Error al registrar. Tal vez el correo ya existe.';
    }
}
include 'includes/header.php';
?>
<h2>Registro</h2>
<div class="card">
<form method="post">
 <div class="form-row"><label>Nombre</label><input required name="name"></div>
 <div class="form-row"><label>Correo</label><input required type="email" name="email"></div>
 <div class="form-row"><label>Contraseña</label><input required type="password" name="password"></div>
 <button type="submit">Registrarme</button>
</form>
</div>
<?php include 'includes/footer.php'; ?>