<?php
include 'includes/config.php';
include 'includes/header.php';

// CRUD for pets: list all, show add form if logged in
if(isset($_GET['action']) && $_GET['action']=='delete' && is_admin()){
    $id = intval($_GET['id']);
    // delete record and file
    $res = $mysqli->query('SELECT photo FROM pets WHERE id='.$id);
    if($r = $res->fetch_assoc()){
        if($r['photo'] && file_exists(__DIR__.'/uploads/'.$r['photo'])) unlink(__DIR__.'/uploads/'.$r['photo']);
    }
    $mysqli->query('DELETE FROM pets WHERE id='.$id);
    header('Location: pets.php');
    exit;
}

if($_SERVER['REQUEST_METHOD']==='POST' && is_logged_in()){
    $name = $mysqli->real_escape_string($_POST['name']);
    $type = $mysqli->real_escape_string($_POST['type']);
    // image upload
    $photo_name = null;
    if(isset($_FILES['photo']) && $_FILES['photo']['error']===0){
        $allowed = ['image/png','image/jpeg','image/jpg','image/webp'];
        if(in_array($_FILES['photo']['type'],$allowed) && $_FILES['photo']['size']<=2*1024*1024){
            $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
            $photo_name = time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
            move_uploaded_file($_FILES['photo']['tmp_name'], __DIR__.'/uploads/'.$photo_name);
        }
    }
    $stmt = $mysqli->prepare('INSERT INTO pets (name,type,photo,owner_id) VALUES (?,?,?,?)');
    $owner = $_SESSION['user_id'];
    $stmt->bind_param('sssi',$name,$type,$photo_name,$owner);
    $stmt->execute();
    header('Location: pets.php');
    exit;
}

// list pets
$res = $mysqli->query('SELECT p.*, u.name as owner FROM pets p LEFT JOIN users u ON p.owner_id=u.id ORDER BY p.created_at DESC');
?>
<h2>Mascotas</h2>
<div class="card">
<?php if(is_logged_in()): ?>
  <h3>Registrar mascota</h3>
  <form method="post" enctype="multipart/form-data">
    <div class="form-row"><label>Nombre</label><input name="name" required></div>
    <div class="form-row"><label>Tipo (Perro/Gato/etc.)</label><input name="type" required></div>
    <div class="form-row"><label>Foto (opcional)</label><input type="file" name="photo" accept="image/*"></div>
    <button type="submit">Guardar</button>
  </form>
<?php else: ?>
  <p class="small">Debes iniciar sesión para registrar mascotas.</p>
<?php endif; ?>
</div>

<div class="card">
  <h3>Listado de mascotas</h3>
  <table class="table">
    <thead><tr><th>Foto</th><th>Nombre</th><th>Tipo</th><th>Propietario</th><th>Acciones</th></tr></thead>
    <tbody>
    <?php while($row=$res->fetch_assoc()): ?>
      <tr>
        <td><?php if($row['photo']): ?><img class="pet" src="/uploads/<?php echo htmlspecialchars($row['photo']); ?>"><?php else: ?>—<?php endif; ?></td>
        <td><?php echo htmlspecialchars($row['name']); ?></td>
        <td><?php echo htmlspecialchars($row['type']); ?></td>
        <td><?php echo htmlspecialchars($row['owner']?: 'N/A'); ?></td>
        <td>
          <?php if(is_admin()): ?>
            <a href="pets.php?action=delete&id=<?php echo $row['id']; ?>" onclick="return confirm('Eliminar?')">Eliminar</a>
          <?php endif; ?>
        </td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
</div>

<?php include 'includes/footer.php'; ?>